<?php
// Функция выводит имена всех подкаталогов в текущем каталоге,
// выполняя рекурсивный обход. Параметр $level задает текущую
// глубину рекурсии.
function printTree(int $level = 1) : void
{
    // Открываем каталог и выходим в случае ошибки
    $dir = opendir('.');
    if (!$dir) return;
    while (($file = readdir($dir)) !== false) {
        // Игнорируем элементы .. и .
        if ($file == '.' || $file == '..') continue;
        // Нам нужны только подкаталоги
        if (!is_dir($file)) continue;
        // Печатаем пробелы, чтобы сместить вывод
        for ($i = 0; $i < $level; $i++) echo '  ';
        // Выводим текущий элемент
        echo $file . PHP_EOL;
        // Входим в текущий подкаталог и печатаем его
        if (!chdir($file)) continue;
        printTree($level + 1);
        // Возвращаемся назад
        chdir('..');
        // Отправляем данные в браузер, чтобы избежать
        // видимости зависания для больших распечаток
        flush();
    }
    closedir($dir);
}

// Выводим остальной текст фиксированным шрифтом
echo '<pre>';
echo '/' . PHP_EOL;
// Входим в корневой каталог и печатаем его
chdir($_SERVER['DOCUMENT_ROOT']);
printTree();
echo '</pre>';
